﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using AntiXssEnc = Microsoft.Security.Application;
using VIRP_WEB.Controls.Survey;

namespace VIRP_WEB.Common
{
    public partial class Survey : BasePage
    {
        private SURVEYS SURVEY
        {
            get
            {
                SURVEYS survey = null;

                if (ViewState["SURVEY"] != null)
                {
                    survey = ViewState["SURVEY"] as SURVEYS;
                }
                else
                {
                    int surveysId = 0;

                    if (!string.IsNullOrEmpty(hideSurveyId.Value))
                        int.TryParse(hideSurveyId.Value.ToString(), out surveysId);
                    else
                    {
                        surveysId = UserSession.CurrentSurveyId;
                        hideSurveyId.Value = UserSession.CurrentSurveyId.ToString();
                    }

                    if (surveysId > 0)
                        survey = ServiceInterfaceManager.SURVEYS_GET_FOR_SURVEY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, surveysId);

                    ViewState["SURVEY"] = survey;
                }

                return survey;
            }
            set
            {
                ViewState["SURVEY"] = value;
            }
        }

        private List<SURVEY_RESULTS> RESULTS
        {
            get
            {
                List<SURVEY_RESULTS> results = null;

                if (ViewState["RESULTS"] != null)
                {
                    results = ViewState["RESULTS"] as List<SURVEY_RESULTS>;
                }
                else
                {
                    int surveysId = 0;

                    if (!string.IsNullOrEmpty(hideSurveyId.Value))
                        int.TryParse(hideSurveyId.Value.ToString(), out surveysId);
                    else
                    {
                        surveysId = UserSession.CurrentSurveyId;
                        hideSurveyId.Value = UserSession.CurrentSurveyId.ToString();
                    }

                    if (surveysId > 0)
                        results = ServiceInterfaceManager.SURVEY_RESULTS_GET_ALL_BY_SURVEY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, surveysId);

                    ViewState["RESULTS"] = results;
                }

                return results;
            }
            set
            {
                ViewState["RESULTS"] = value;
            }
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
                ServiceInterfaceManager.LogInformation("PAGE_LOAD", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                base.Page_Load(sender, e);

                lblResult.Text = string.Empty;

                if (UserSession == null || UserSession.CurrentRegistryId <= 0)
                {
                    Response.Redirect("~/Default.aspx", false);
                }
                else if (UserSession.CurrentSurveyId <= 0)
                {
                    Response.Redirect("~/Common/Surveys.aspx", false);
                }
                else
                {
                    if (ServiceInterfaceManager.USER_ROLES_GET_BY_REGISTRYID_USERNAME_SET_READONLY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId))
                    {
                        SetReadOnly();
                    }
                    if (!Page.IsPostBack)
                    {
                        //BuildCommonMenu();
                    }

                    SetupForm();
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private void SetReadOnly()
        {
            lblResult.Text = "You are not able to edit information on this page.<br /><br />";
            btnSave.Enabled = false;
            btnSaveComplete.Enabled = false;
            btnCompleteAndPreview.Enabled = false;
            linkEdit.Visible = false;
        }

        protected void LinkEdit_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                UserSession.PageMode = PageModes.Edit;
                Response.Redirect("~/Common/Surveys.aspx", false);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnSave_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                if (SaveForm())
                {
                    SURVEYS survey = SURVEY;
                    if (survey != null)
                    {
                        survey.SURVEY_STATUS = "IN PROGRESS";
                        survey.SURVEYS_ID = ServiceInterfaceManager.SURVEYS_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, survey);
                        SURVEY = survey;
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnSaveComplete_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                if (SaveForm())
                {
                    SURVEYS survey = SURVEY;
                    if (survey != null)
                    {
                        survey.SURVEY_STATUS = "COMPLETE";
                        survey.SURVEYS_ID = ServiceInterfaceManager.SURVEYS_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, survey);
                        SURVEY = survey;
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnCompleteAndPreview_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                if (SaveForm())
                {
                    SURVEYS survey = SURVEY;
                    if (survey != null)
                    {
                        survey.SURVEY_STATUS = "COMPLETE";
                        survey.SURVEYS_ID = ServiceInterfaceManager.SURVEYS_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, survey);
                        SURVEY = survey;
                    }
                }

                NotesManager notesManager = new NotesManager();
                if (notesManager.ViaData == null)
                {
                    lblResult.Text = "To submit a note to CPRS, you must have an active patient open in CPRS and select the link in the Tools menu in CPRS to navigate to VIRP.";
                    return;
                }

                Response.Redirect("NoteTemplatePreview.aspx");
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        protected void BtnCancel_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                UserSession.CurrentSurveyId = 0;
                Response.Redirect("~/Common/Surveys.aspx", false);
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private void SetupForm()
        {
            SETTINGS setting = null;
            bool uploadNoteTemplates = false;
            setting = ServiceInterfaceManager.SETTINGS_GET_REGISTRYNAME(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, "UploadNoteTemplates");
            if (setting != null && setting.VALUE == "1")
            {
                uploadNoteTemplates = true;
            }
            if (uploadNoteTemplates)
            {
                btnCompleteAndPreview.Visible = true;
                btnSaveComplete.Visible = false;
            }
            else
            {
                btnCompleteAndPreview.Visible = false;
                btnSaveComplete.Visible = true;
            }

            tblForm.Visible = false;

            viewPatient.LoadForm(UserSession.CurrentPatientId);

            SURVEYS survey = SURVEY;
            if (survey != null)
            {
                tblForm.Visible = true;

                if (survey.STD_SURVEY_TYPE != null)
                    lblPageTitle.Text = AntiXssEnc.Encoder.HtmlEncode(survey.STD_SURVEY_TYPE.NAME);

                List<SURVEY_RESULTS> results = RESULTS;
                if (results != null)
                {
                    //Select distinct question ids
                    List<Int32> questionIds = results.Select(data => data.STD_QUESTION_ID).Distinct().ToList();
                    if (questionIds != null && questionIds.Count > 0)
                    {
                        TableCell newCell = null;
                        TableRow newRow = null;
                        int rowIndex = 0;
                        bool showCommentBox = false;
                        bool showSeparator = true;

                        foreach (Int32 questionId in questionIds)
                        {
                            List<SURVEY_RESULTS> questions = results.Where(data => data.STD_QUESTION_ID == questionId).ToList();
                            if (questions != null && questions.Count > 0)
                            {
                                Label lbl = new Label();

                                //Add question number and text to table
                                STD_QUESTION stdQuestion = questions.First().STD_QUESTION;
                                if (stdQuestion != null)
                                {
                                    if (stdQuestion.STD_QUESTION_TYPE_ID == (int)SurveyQuestionTypes.MultipleChoice)
                                    {
                                        showCommentBox = true;
                                        showSeparator = true;

                                        var control = (SurveyQuestionMultipleChoice)LoadControl("~/Controls/Survey/SurveyQuestionMultipleChoice.ascx");
                                        control.Questions = questions;
                                        control.BuildQuestion();
                                        newCell = new TableCell();
                                        newCell.Controls.Add(control);

                                        newRow = new TableRow();
                                        newRow.Cells.Add(newCell);

                                        tblForm.Rows.AddAt(rowIndex, newRow);
                                        rowIndex++;
                                    }
                                    else if (stdQuestion.STD_QUESTION_TYPE_ID == (int)SurveyQuestionTypes.Scale)
                                    {
                                        showCommentBox = true;
                                        showSeparator = true;

                                        var control = (SurveyQuestionScale)LoadControl("~/Controls/Survey/SurveyQuestionScale.ascx");
                                        control.Questions = questions;
                                        control.BuildQuestion();
                                        newCell = new TableCell();
                                        newCell.Controls.Add(control);

                                        newRow = new TableRow();
                                        newRow.Cells.Add(newCell);

                                        tblForm.Rows.AddAt(rowIndex, newRow);
                                        rowIndex++;
                                    }
                                    else if (stdQuestion.STD_QUESTION_TYPE_ID == (int)SurveyQuestionTypes.Description)
                                    {
                                        //Description
                                        showCommentBox = false;
                                        showSeparator = false;

                                        var control = (SurveyQuestionDescription)LoadControl("~/Controls/Survey/SurveyQuestionDescription.ascx");
                                        control.Questions = questions;
                                        control.BuildQuestion();
                                        newCell = new TableCell();
                                        newCell.Controls.Add(control);

                                        newRow = new TableRow();
                                        newRow.Cells.Add(newCell);

                                        tblForm.Rows.AddAt(rowIndex, newRow);
                                        rowIndex++;
                                    }
                                    else if (stdQuestion.STD_QUESTION_TYPE_ID == (int)SurveyQuestionTypes.FreeText)
                                    {
                                        showCommentBox = true;
                                        showSeparator = true;

                                        var control = (SurveyQuestionFreeText)LoadControl("~/Controls/Survey/SurveyQuestionFreeText.ascx");
                                        control.Questions = questions;
                                        control.BuildQuestion();

                                        newCell = new TableCell();
                                        newCell.Controls.Add(control);

                                        newRow = new TableRow();
                                        newRow.Cells.Add(newCell);

                                        tblForm.Rows.AddAt(rowIndex, newRow);
                                        rowIndex++;
                                    }
                                    else if (stdQuestion.STD_QUESTION_TYPE_ID == (int)SurveyQuestionTypes.Calculation)
                                    {
                                        showCommentBox = false;
                                        showSeparator = false;

                                        var control = (SurveyQuestionCalculation)LoadControl("~/Controls/Survey/SurveyQuestionCalculation.ascx");
                                        control.Questions = questions;
                                        control.BuildQuestion();

                                        newCell = new TableCell();
                                        newCell.Controls.Add(control);

                                        newRow = new TableRow();
                                        newRow.Cells.Add(newCell);

                                        tblForm.Rows.AddAt(rowIndex, newRow);
                                        rowIndex++;
                                    }

                                    #region Add Comment TextBox
                                    if (showCommentBox)
                                    {
                                        newCell = new TableCell();
                                        newCell.Controls.Add(new LiteralControl("<br />"));
                                        newCell.Controls.Add(new Label() { Text = "Comments: " });
                                        TextBox cmttxt = new TextBox();
                                        cmttxt.Width = Unit.Pixel(200);
                                        cmttxt.ID = "cmntText" + questions[0].SURVEY_RESULT_ID.ToString();
                                        cmttxt.Text = questions[0].COMMENTS_TEXT;
                                        lbl.AssociatedControlID = cmttxt.ID;
                                        cmttxt.ToolTip = "Enter your comments for Q." + stdQuestion.QUESTION_NUMBER;

                                        newCell.Controls.Add(cmttxt);

                                        newRow = new TableRow();
                                        newRow.Cells.Add(newCell);

                                        tblForm.Rows.AddAt(rowIndex, newRow);
                                        rowIndex++;
                                    }
                                    #endregion

                                    //Add blank row/cell
                                    newCell = new TableCell();
                                    newCell.Text = "&nbsp;";

                                    if (showSeparator)
                                    {
                                        var hrControl = new LiteralControl("<hr class=\"virp-survey-line\" />");
                                        newCell.Controls.Add(hrControl);
                                    }
                                    newCell.Controls.Add(new LiteralControl("<br />"));

                                    newRow = new TableRow();
                                    newRow.Cells.Add(newCell);

                                    tblForm.Rows.AddAt(rowIndex, newRow);
                                    rowIndex++;
                                }
                            }
                        }
                    }
                }
            }
        }

        private bool SaveForm()
        {
            bool objReturn = false;

            //Retrieve results from ViewState
            List<SURVEY_RESULTS> results = RESULTS;
            if (results == null)
            {
                //TODO: Should not be null, however if it is reload everything based on Survey ID

                //int id = 0;
                //int.TryParse(hideSurveyId.Value.ToString(), out id);
                //if (id > 0)
                //{
                //}
            }

            if (results != null)
            {
                if (tblForm.Rows != null)
                {
                    foreach (TableRow row in tblForm.Rows)
                    {
                        if (row.Cells != null && row.Cells.Count > 0)
                        {
                            if (row.Cells[0].Controls != null && row.Cells[0].Controls.Count > 0)
                            {
                                if (row.Cells[0].Controls[0] is SurveyQuestionMultipleChoice)
                                {
                                    //Multiple Choice
                                    var control = row.Cells[0].Controls[0] as SurveyQuestionMultipleChoice;
                                    control.Results = results;
                                    control.SaveQuestion();
                                }
                                else if (row.Cells[0].Controls[0] is SurveyQuestionScale)
                                {
                                    //Scale
                                    var control = row.Cells[0].Controls[0] as SurveyQuestionScale;
                                    control.Results = results;
                                    control.SaveQuestion();
                                }
                                else if (row.Cells[0].Controls[0] is SurveyQuestionFreeText)
                                {
                                    //Free Text
                                    var control = row.Cells[0].Controls[0] as SurveyQuestionFreeText;
                                    control.Results = results;
                                    control.SaveQuestion();
                                }
                                else if (row.Cells[0].Controls[0] is SurveyQuestionCalculation)
                                {
                                    //Calculation
                                    var control = row.Cells[0].Controls[0] as SurveyQuestionCalculation;
                                    control.Results = results;
                                    control.SaveQuestion();
                                }
                                else
                                {
                                    foreach (Control ctr in row.Cells[0].Controls)
                                    {
                                        if (ctr is TextBox)
                                        {
                                            TextBox ctrl = ctr as TextBox;
                                            if (ctrl != null)
                                            {
                                                int resultId = 0;
                                                if (int.TryParse(ctrl.ID.Replace("cmntText", ""), out resultId))
                                                {
                                                    foreach (SURVEY_RESULTS result in results)
                                                    {
                                                        if (result.SURVEY_RESULT_ID == resultId)
                                                            result.COMMENTS_TEXT = ctrl.Text;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                if (ServiceInterfaceManager.SURVEY_RESULTS_SAVE_ALL(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, results))
                {
                    RESULTS = results;
                    lblResult.Text = "Save Successful<br /><br />";
                    objReturn = true;
                }
                else
                {
                    lblResult.Text = "Error saving Survey values, please try again.<br /><br />";
                    objReturn = false;
                }
            }

            return objReturn;
        }
    }
}